#version 330 core

in vec2 out_uvs;
out vec4 FragColour;

uniform sampler2D inTex;
uniform float thresholdF;
uniform float thresholdSmoothF;
uniform float exposureF;
uniform int thresholdModeL;
uniform int presentViewL; // if true, we're looking at input preProc so get it ready for view

void main()
{
    FragColour = abs(texture(inTex, out_uvs.xy));
    
    // we know the format is RGBA since swizzling to it doesn't change anything
    // in the previous upload, we went RGBA -> GBAR
    // in the previous download, we went ARGB -> RGBA
    FragColour = FragColour.gbar;
    
    float thresholdPercent = 0;
    float greyF;

    // thresholding with smooth
    if(thresholdF > 0.0)
    {
        vec3 mult;

        if(thresholdModeL == 1) // luminance mode
        {
            greyF = (FragColour.r + FragColour.b + FragColour.g) * 0.333;
            mult = smoothstep(thresholdF - thresholdSmoothF, thresholdF + thresholdSmoothF, vec3(greyF));
        }
        else
        {
            mult = smoothstep(thresholdF - thresholdSmoothF, thresholdF + thresholdSmoothF, FragColour.rgb);
        }

        FragColour.rgb *= mult;
    }
    
    if(presentViewL == 1)
    {
        FragColour = FragColour.argb; // this used to be done on GPU->CPU download, but we'll do it in the shader instead
    }
    else
    {
        // don't swizzle as we'll do the radBlur frag over this
        FragColour.rgb *= vec3(FragColour.a); // remove alpha by multiplying RGB by alpha then making the alpha solid 1.0
        FragColour.a = 1.0;
    }
}

